#version 330
#extension GL_EXT_gpu_shader4 : enable
//mandelbrot orbit trap testMod01.fsh  by asneakyfatcat
//https://www.shadertoy.com/view/Mdy3zt
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.5  //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy;
    //uv.x *= iResolution.x/iResolution.y;
    float dist = 0.;
    uv.x = -2.+4.*uv.x;
    uv.y = -1.+2.*uv.y;
    // comment the next line to see the fully zoomed out view
    uv *=pow(.1,4.+cos(.1*iTime));
    uv.x += .275015;//;
    uv.y += .0060445;//
    //uv /= 5.;
    vec4 col =vec4(1.);
    vec2 z = vec2(0.0);
    
    int trap=0;
    for(int i = 0; i < 400; i++){
        if(dot(z,z)>4.){trap = i;break;}
        dist = min( 1e20, dot(z,z))+cos(float(i)*12.+3.*iTime);
        z = mat2(z,-z.y,z.x)*z + uv;
    }
    dist = sqrt(dist);
	float orb = sqrt(float(trap))/64.;
    gl_FragColor=vec4(0.,log(dist)*sqrt(dist)-orb-orb,log(dist)*sqrt(dist-abs(sin(iTime))),1.);

 //   if(orb == 0.){fragColor = vec4(0.);}
    //fragColor = (orb!=0. ? 1.-orb*vec4(9.,5.,3.,0.):vec4(0.));
}
